/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdSplitterUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSession;

public class PortletSessionTracker {
    private static ConcurrentMap<String, Set<HttpSession>> _sessions = new ConcurrentHashMap<String, Set<HttpSession>>();

    public static void add(HttpSession session) {
        Set previousSessions;
        Set<Object> sessions;
        String sessionId = session.getId();
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter()) {
            sessionId = CompoundSessionIdSplitterUtil.parseSessionId(sessionId);
        }
        if ((sessions = (ConcurrentHashSet<HttpSession>)_sessions.get(sessionId)) == null && (previousSessions = (Set)_sessions.putIfAbsent(sessionId, sessions = new ConcurrentHashSet<HttpSession>())) != null) {
            sessions = previousSessions;
        }
        sessions.add(session);
    }

    public static void invalidate(String sessionId) {
        Set sessions;
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter()) {
            sessionId = CompoundSessionIdSplitterUtil.parseSessionId(sessionId);
        }
        if ((sessions = (Set)_sessions.remove(sessionId)) == null) {
            return;
        }
        for (HttpSession session : sessions) {
            try {
                session.invalidate();
            }
            catch (Exception exception) {}
        }
    }
}

