/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.ServletContext;

public class ServletContextUtil {
    public static final String PATH_WEB_XML = "/WEB-INF/web.xml";
    public static final String URI_ATTRIBUTE = ServletContextUtil.class.getName().concat(".rootURI");
    private static final String _EXT_CLASS = ".class";
    private static final String _EXT_JAR = ".jar";
    private static Log _log = LogFactoryUtil.getLog(ServletContextUtil.class);

    public static Set<String> getClassNames(ServletContext servletContext) throws IOException {
        HashSet<String> classNames = new HashSet<String>();
        ServletContextUtil._getClassNames(servletContext, "/WEB-INF/classes", classNames);
        ServletContextUtil._getClassNames(servletContext, "/WEB-INF/lib", classNames);
        return classNames;
    }

    public static long getLastModified(ServletContext servletContext) {
        return ServletContextUtil.getLastModified(servletContext, "/");
    }

    public static long getLastModified(ServletContext servletContext, String path) {
        return ServletContextUtil.getLastModified(servletContext, path, false);
    }

    public static long getLastModified(ServletContext servletContext, String path, boolean cache) {
        String lastModifiedCacheKey = null;
        if (cache) {
            lastModifiedCacheKey = ServletContextUtil.class.getName();
            Long lastModified = (Long)servletContext.getAttribute(lastModifiedCacheKey = lastModifiedCacheKey.concat(".").concat(path));
            if (lastModified != null) {
                return lastModified;
            }
        }
        String curPath = null;
        long lastModified = 0L;
        LinkedList<String> pathQueue = new LinkedList<String>();
        pathQueue.offer(path);
        while ((curPath = (String)pathQueue.poll()) != null) {
            if (curPath.charAt(curPath.length() - 1) == '/') {
                Set pathSet = servletContext.getResourcePaths(curPath);
                if (pathSet == null) continue;
                pathQueue.addAll(pathSet);
                continue;
            }
            try {
                URL url = servletContext.getResource(curPath);
                if (url == null) {
                    _log.error("Resource URL for " + curPath + " is null");
                    continue;
                }
                URLConnection urlConnection = url.openConnection();
                if (urlConnection.getLastModified() <= lastModified) continue;
                lastModified = urlConnection.getLastModified();
            }
            catch (IOException ioe) {
                _log.error(ioe, ioe);
            }
        }
        if (cache) {
            servletContext.setAttribute(lastModifiedCacheKey, (Object)new Long(lastModified));
        }
        return lastModified;
    }

    public static String getResourcePath(URL url) throws URISyntaxException {
        URI uri = ServletContextUtil.getResourceURI(url);
        return uri.toString();
    }

    public static URI getResourceURI(URL url) throws URISyntaxException {
        return ServletContextUtil._getResourceURI(url, url.getPath());
    }

    public static String getRootPath(ServletContext servletContext) throws MalformedURLException {
        URI rootURI = ServletContextUtil.getRootURI(servletContext);
        return rootURI.toString();
    }

    public static URI getRootURI(ServletContext servletContext) throws MalformedURLException {
        URI rootURI = (URI)servletContext.getAttribute(URI_ATTRIBUTE);
        if (rootURI != null) {
            return rootURI;
        }
        try {
            URL rootURL = servletContext.getResource(PATH_WEB_XML);
            String path = rootURL.getPath();
            int index = path.indexOf(PATH_WEB_XML);
            if (index < 0) {
                throw new MalformedURLException("Invalid URL " + rootURL);
            }
            path = index == 0 ? "/" : path.substring(0, index);
            rootURI = ServletContextUtil._getResourceURI(rootURL, path);
            servletContext.setAttribute(URI_ATTRIBUTE, (Object)rootURI);
        }
        catch (URISyntaxException urise) {
            throw new MalformedURLException(urise.getMessage());
        }
        return rootURI;
    }

    private static String _getClassName(String path) {
        return ServletContextUtil._getClassName(null, path);
    }

    private static String _getClassName(String rootPath, String path) {
        String className = path.substring(0, path.length() - _EXT_CLASS.length());
        if (rootPath != null) {
            className = className.substring(rootPath.length() + 1);
        }
        className = StringUtil.replace(className, '/', '.');
        return className;
    }

    private static void _getClassNames(ServletContext servletContext, String rootPath, Set<String> classNames) throws IOException {
        ServletContextUtil._getClassNames(servletContext, rootPath, servletContext.getResourcePaths(rootPath), classNames);
    }

    private static void _getClassNames(ServletContext servletContext, String rootPath, Set<String> paths, Set<String> classNames) throws IOException {
        if (paths == null) {
            return;
        }
        for (String path : paths) {
            if (path.endsWith(_EXT_CLASS)) {
                String className = ServletContextUtil._getClassName(rootPath, path);
                classNames.add(className);
                continue;
            }
            if (path.endsWith(_EXT_JAR)) {
                JarEntry jarEntry;
                JarInputStream jarFile = new JarInputStream(servletContext.getResourceAsStream(path));
                while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.endsWith(_EXT_CLASS)) continue;
                    String className = ServletContextUtil._getClassName(jarEntryName);
                    classNames.add(className);
                }
                jarFile.close();
                continue;
            }
            if (!path.endsWith("/")) continue;
            ServletContextUtil._getClassNames(servletContext, rootPath, servletContext.getResourcePaths(path), classNames);
        }
    }

    private static URI _getResourceURI(URL url, String path) throws URISyntaxException {
        return new URI(url.getProtocol(), path, null);
    }
}

