/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade.dao.orm;

import com.liferay.portal.kernel.upgrade.dao.orm.UpgradeOptimizedResultSetHandler;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UpgradeOptimizedPreparedStatementHandler
implements InvocationHandler {
    private PreparedStatement _preparedStatement;

    public UpgradeOptimizedPreparedStatementHandler(PreparedStatement preparedStatement) {
        this._preparedStatement = preparedStatement;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        try {
            String methodName = method.getName();
            if (methodName.equals("executeQuery")) {
                return this.executeQuery();
            }
            return method.invoke((Object)this._preparedStatement, arguments);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected ResultSet executeQuery() throws SQLException {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        ResultSet resultSet = this._preparedStatement.executeQuery();
        return (ResultSet)ProxyUtil.newProxyInstance(classLoader, new Class[]{ResultSet.class}, new UpgradeOptimizedResultSetHandler(resultSet));
    }
}

