/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.security.pacl.permission.PortalFilePermission;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.SystemProperties;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Properties;

public class FileUtil {
    private static File _file;

    public static void copyDirectory(java.io.File source, java.io.File destination) throws IOException {
        PortalFilePermission.checkCopy(FileUtil._getPath(source), FileUtil._getPath(destination));
        FileUtil.getFile().copyDirectory(source, destination);
    }

    public static void copyDirectory(String sourceDirName, String destinationDirName) throws IOException {
        PortalFilePermission.checkCopy(sourceDirName, destinationDirName);
        FileUtil.getFile().copyDirectory(sourceDirName, destinationDirName);
    }

    public static void copyFile(java.io.File source, java.io.File destination) throws IOException {
        PortalFilePermission.checkCopy(FileUtil._getPath(source), FileUtil._getPath(destination));
        FileUtil.getFile().copyFile(source, destination);
    }

    public static void copyFile(java.io.File source, java.io.File destination, boolean lazy) throws IOException {
        PortalFilePermission.checkCopy(FileUtil._getPath(source), FileUtil._getPath(destination));
        FileUtil.getFile().copyFile(source, destination, lazy);
    }

    public static void copyFile(String source, String destination) throws IOException {
        PortalFilePermission.checkCopy(source, destination);
        FileUtil.getFile().copyFile(source, destination);
    }

    public static void copyFile(String source, String destination, boolean lazy) throws IOException {
        PortalFilePermission.checkCopy(source, destination);
        FileUtil.getFile().copyFile(source, destination, lazy);
    }

    public static java.io.File createTempFile() {
        PortalFilePermission.checkWrite(SystemProperties.get("java.io.tmpdir"));
        return FileUtil.getFile().createTempFile();
    }

    public static java.io.File createTempFile(byte[] bytes) throws IOException {
        PortalFilePermission.checkWrite(SystemProperties.get("java.io.tmpdir"));
        return FileUtil.getFile().createTempFile(bytes);
    }

    public static java.io.File createTempFile(InputStream is) throws IOException {
        PortalFilePermission.checkWrite(SystemProperties.get("java.io.tmpdir"));
        return FileUtil.getFile().createTempFile(is);
    }

    public static java.io.File createTempFile(String extension) {
        PortalFilePermission.checkWrite(SystemProperties.get("java.io.tmpdir"));
        return FileUtil.getFile().createTempFile(extension);
    }

    public static java.io.File createTempFile(String prefix, String extension) {
        PortalFilePermission.checkWrite(SystemProperties.get("java.io.tmpdir"));
        return FileUtil.getFile().createTempFile(prefix, extension);
    }

    public static String createTempFileName() {
        PortalFilePermission.checkWrite(SystemProperties.get("java.io.tmpdir"));
        return FileUtil.getFile().createTempFileName();
    }

    public static String createTempFileName(String extension) {
        PortalFilePermission.checkWrite(SystemProperties.get("java.io.tmpdir"));
        return FileUtil.getFile().createTempFileName(extension);
    }

    public static String createTempFileName(String prefix, String extension) {
        PortalFilePermission.checkWrite(SystemProperties.get("java.io.tmpdir"));
        return FileUtil.getFile().createTempFileName(prefix, extension);
    }

    public static java.io.File createTempFolder() {
        PortalFilePermission.checkWrite(SystemProperties.get("java.io.tmpdir"));
        return FileUtil.getFile().createTempFolder();
    }

    public static String decodeSafeFileName(String fileName) {
        return FileUtil.getFile().decodeSafeFileName(fileName);
    }

    public static boolean delete(java.io.File file) {
        PortalFilePermission.checkDelete(FileUtil._getPath(file));
        return FileUtil.getFile().delete(file);
    }

    public static boolean delete(String file) {
        PortalFilePermission.checkDelete(file);
        return FileUtil.getFile().delete(file);
    }

    public static void deltree(java.io.File directory) {
        PortalFilePermission.checkDelete(FileUtil._getPath(directory));
        FileUtil.getFile().deltree(directory);
    }

    public static void deltree(String directory) {
        PortalFilePermission.checkDelete(directory);
        FileUtil.getFile().deltree(directory);
    }

    public static String encodeSafeFileName(String fileName) {
        return FileUtil.getFile().encodeSafeFileName(fileName);
    }

    public static boolean exists(java.io.File file) {
        PortalFilePermission.checkRead(FileUtil._getPath(file));
        return FileUtil.getFile().exists(file);
    }

    public static boolean exists(String fileName) {
        PortalFilePermission.checkRead(fileName);
        return FileUtil.getFile().exists(fileName);
    }

    public static String extractText(InputStream is, String fileName) {
        return FileUtil.getFile().extractText(is, fileName);
    }

    public static String[] find(String directory, String includes, String excludes) {
        PortalFilePermission.checkRead(directory);
        return FileUtil.getFile().find(directory, includes, excludes);
    }

    public static String getAbsolutePath(java.io.File file) {
        return FileUtil.getFile().getAbsolutePath(file);
    }

    public static byte[] getBytes(java.io.File file) throws IOException {
        PortalFilePermission.checkRead(FileUtil._getPath(file));
        return FileUtil.getFile().getBytes(file);
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        return FileUtil.getFile().getBytes(is);
    }

    public static byte[] getBytes(InputStream is, int bufferSize) throws IOException {
        return FileUtil.getFile().getBytes(is);
    }

    public static byte[] getBytes(InputStream is, int bufferSize, boolean cleanUpStream) throws IOException {
        return FileUtil.getFile().getBytes(is, bufferSize, cleanUpStream);
    }

    public static String getExtension(String fileName) {
        return FileUtil.getFile().getExtension(fileName);
    }

    public static File getFile() {
        PortalRuntimePermission.checkGetBeanProperty(FileUtil.class);
        return _file;
    }

    public static String getMD5Checksum(java.io.File file) throws IOException {
        return FileUtil.getFile().getMD5Checksum(file);
    }

    public static String getPath(String fullFileName) {
        return FileUtil.getFile().getPath(fullFileName);
    }

    public static String getShortFileName(String fullFileName) {
        return FileUtil.getFile().getShortFileName(fullFileName);
    }

    public static boolean isAscii(java.io.File file) throws IOException {
        PortalFilePermission.checkRead(FileUtil._getPath(file));
        return FileUtil.getFile().isAscii(file);
    }

    public static boolean isSameContent(java.io.File file, byte[] bytes, int length) {
        PortalFilePermission.checkRead(FileUtil._getPath(file));
        return FileUtil.getFile().isSameContent(file, bytes, length);
    }

    public static boolean isSameContent(java.io.File file, String s) {
        PortalFilePermission.checkRead(FileUtil._getPath(file));
        return FileUtil.getFile().isSameContent(file, s);
    }

    public static String[] listDirs(java.io.File file) {
        PortalFilePermission.checkRead(FileUtil._getPath(file));
        return FileUtil.getFile().listDirs(file);
    }

    public static String[] listDirs(String fileName) {
        PortalFilePermission.checkRead(fileName);
        return FileUtil.getFile().listDirs(fileName);
    }

    public static String[] listFiles(java.io.File file) {
        PortalFilePermission.checkRead(FileUtil._getPath(file));
        return FileUtil.getFile().listFiles(file);
    }

    public static String[] listFiles(String fileName) {
        PortalFilePermission.checkRead(fileName);
        return FileUtil.getFile().listFiles(fileName);
    }

    public static void mkdirs(String pathName) {
        PortalFilePermission.checkCopy(pathName, pathName);
        FileUtil.getFile().mkdirs(pathName);
    }

    public static boolean move(java.io.File source, java.io.File destination) {
        PortalFilePermission.checkMove(FileUtil._getPath(source), FileUtil._getPath(destination));
        return FileUtil.getFile().move(source, destination);
    }

    public static boolean move(String sourceFileName, String destinationFileName) {
        PortalFilePermission.checkMove(sourceFileName, destinationFileName);
        return FileUtil.getFile().move(sourceFileName, destinationFileName);
    }

    public static String read(java.io.File file) throws IOException {
        PortalFilePermission.checkRead(FileUtil._getPath(file));
        return FileUtil.getFile().read(file);
    }

    public static String read(java.io.File file, boolean raw) throws IOException {
        PortalFilePermission.checkRead(FileUtil._getPath(file));
        return FileUtil.getFile().read(file, raw);
    }

    public static String read(String fileName) throws IOException {
        PortalFilePermission.checkRead(fileName);
        return FileUtil.getFile().read(fileName);
    }

    public static String replaceSeparator(String fileName) {
        return FileUtil.getFile().replaceSeparator(fileName);
    }

    public static java.io.File[] sortFiles(java.io.File[] files) {
        return FileUtil.getFile().sortFiles(files);
    }

    public static String stripExtension(String fileName) {
        return FileUtil.getFile().stripExtension(fileName);
    }

    public static List<String> toList(Reader reader) {
        return FileUtil.getFile().toList(reader);
    }

    public static List<String> toList(String fileName) {
        return FileUtil.getFile().toList(fileName);
    }

    public static Properties toProperties(FileInputStream fis) {
        return FileUtil.getFile().toProperties(fis);
    }

    public static Properties toProperties(String fileName) {
        PortalFilePermission.checkRead(fileName);
        return FileUtil.getFile().toProperties(fileName);
    }

    public static void touch(java.io.File file) throws IOException {
        PortalFilePermission.checkWrite(FileUtil._getPath(file));
        FileUtil.getFile().touch(file);
    }

    public static void touch(String fileName) throws IOException {
        PortalFilePermission.checkWrite(fileName);
        FileUtil.getFile().touch(fileName);
    }

    public static void unzip(java.io.File source, java.io.File destination) {
        PortalFilePermission.checkCopy(FileUtil._getPath(source), FileUtil._getPath(destination));
        FileUtil.getFile().unzip(source, destination);
    }

    public static void write(java.io.File file, byte[] bytes) throws IOException {
        FileUtil.write(file, bytes, false);
    }

    public static void write(java.io.File file, byte[] bytes, boolean append) throws IOException {
        PortalFilePermission.checkWrite(FileUtil._getPath(file));
        FileUtil.getFile().write(file, bytes, append);
    }

    public static void write(java.io.File file, byte[] bytes, int offset, int length) throws IOException {
        FileUtil.write(file, bytes, offset, length, false);
    }

    public static void write(java.io.File file, byte[] bytes, int offset, int length, boolean append) throws IOException {
        PortalFilePermission.checkWrite(FileUtil._getPath(file));
        FileUtil.getFile().write(file, bytes, offset, length, append);
    }

    public static void write(java.io.File file, InputStream is) throws IOException {
        PortalFilePermission.checkWrite(FileUtil._getPath(file));
        FileUtil.getFile().write(file, is);
    }

    public static void write(java.io.File file, String s) throws IOException {
        PortalFilePermission.checkWrite(FileUtil._getPath(file));
        FileUtil.getFile().write(file, s);
    }

    public static void write(java.io.File file, String s, boolean lazy) throws IOException {
        PortalFilePermission.checkWrite(FileUtil._getPath(file));
        FileUtil.getFile().write(file, s, lazy);
    }

    public static void write(java.io.File file, String s, boolean lazy, boolean append) throws IOException {
        PortalFilePermission.checkWrite(FileUtil._getPath(file));
        FileUtil.getFile().write(file, s, lazy, append);
    }

    public static void write(String fileName, byte[] bytes) throws IOException {
        PortalFilePermission.checkWrite(fileName);
        FileUtil.getFile().write(fileName, bytes);
    }

    public static void write(String fileName, InputStream is) throws IOException {
        PortalFilePermission.checkWrite(fileName);
        FileUtil.getFile().write(fileName, is);
    }

    public static void write(String fileName, String s) throws IOException {
        PortalFilePermission.checkWrite(fileName);
        FileUtil.getFile().write(fileName, s);
    }

    public static void write(String fileName, String s, boolean lazy) throws IOException {
        PortalFilePermission.checkWrite(fileName);
        FileUtil.getFile().write(fileName, s, lazy);
    }

    public static void write(String fileName, String s, boolean lazy, boolean append) throws IOException {
        PortalFilePermission.checkWrite(fileName);
        FileUtil.getFile().write(fileName, s, lazy, append);
    }

    public static void write(String pathName, String fileName, String s) throws IOException {
        PortalFilePermission.checkWrite(pathName);
        FileUtil.getFile().write(pathName, fileName, s);
    }

    public static void write(String pathName, String fileName, String s, boolean lazy) throws IOException {
        PortalFilePermission.checkWrite(pathName);
        FileUtil.getFile().write(pathName, fileName, s, lazy);
    }

    public static void write(String pathName, String fileName, String s, boolean lazy, boolean append) throws IOException {
        PortalFilePermission.checkWrite(pathName);
        FileUtil.getFile().write(pathName, fileName, s, lazy, append);
    }

    public void setFile(File file) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _file = file;
    }

    private static String _getPath(java.io.File file) {
        if (file == null) {
            return null;
        }
        return file.getPath();
    }
}

