/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ServiceContextFactory {
    public static ServiceContext getInstance(HttpServletRequest request) throws PortalException, SystemException {
        String assetTagNamesString;
        ServiceContext serviceContext = new ServiceContext();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            serviceContext.setCompanyId(themeDisplay.getCompanyId());
            serviceContext.setLanguageId(themeDisplay.getLanguageId());
            serviceContext.setLayoutFullURL(PortalUtil.getCanonicalURL(PortalUtil.getLayoutFullURL(themeDisplay), themeDisplay, themeDisplay.getLayout(), true));
            serviceContext.setLayoutURL(PortalUtil.getCanonicalURL(PortalUtil.getLayoutURL(themeDisplay), themeDisplay, themeDisplay.getLayout(), true));
            serviceContext.setPathMain(PortalUtil.getPathMain());
            serviceContext.setPathFriendlyURLPrivateGroup(PortalUtil.getPathFriendlyURLPrivateGroup());
            serviceContext.setPathFriendlyURLPrivateUser(PortalUtil.getPathFriendlyURLPrivateUser());
            serviceContext.setPathFriendlyURLPublic(PortalUtil.getPathFriendlyURLPublic());
            serviceContext.setPlid(themeDisplay.getPlid());
            serviceContext.setPortalURL(PortalUtil.getPortalURL(request));
            serviceContext.setScopeGroupId(themeDisplay.getScopeGroupId());
            serviceContext.setSignedIn(themeDisplay.isSignedIn());
            serviceContext.setTimeZone(themeDisplay.getTimeZone());
            User user = themeDisplay.getUser();
            serviceContext.setUserDisplayURL(user.getDisplayURL(themeDisplay));
            serviceContext.setUserId(user.getUserId());
        } else {
            long companyId = PortalUtil.getCompanyId(request);
            serviceContext.setCompanyId(companyId);
            serviceContext.setPathFriendlyURLPrivateGroup(PortalUtil.getPathFriendlyURLPrivateGroup());
            serviceContext.setPathFriendlyURLPrivateUser(PortalUtil.getPathFriendlyURLPrivateUser());
            serviceContext.setPathFriendlyURLPublic(PortalUtil.getPathFriendlyURLPublic());
            serviceContext.setPathMain(PortalUtil.getPathMain());
            User user = null;
            try {
                user = PortalUtil.getUser(request);
            }
            catch (NoSuchUserException noSuchUserException) {}
            if (user != null) {
                serviceContext.setSignedIn(!user.isDefaultUser());
                serviceContext.setUserId(user.getUserId());
            } else {
                serviceContext.setSignedIn(false);
            }
        }
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        Map parameters = request.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            String name = (String)entry.getKey();
            Object[] values = (String[])entry.getValue();
            if (!ArrayUtil.isNotEmpty(values)) continue;
            if (values.length == 1) {
                attributes.put(name, (Serializable)values[0]);
                continue;
            }
            attributes.put(name, (Serializable)values);
        }
        serviceContext.setAttributes(attributes);
        String cmd = ParamUtil.getString(request, "cmd");
        serviceContext.setCommand(cmd);
        String currentURL = PortalUtil.getCurrentURL(request);
        serviceContext.setCurrentURL(currentURL);
        long formDateLong = ParamUtil.getLong(request, "formDate");
        if (formDateLong > 0L) {
            Date formDate = new Date(formDateLong);
            serviceContext.setFormDate(formDate);
        }
        boolean addGroupPermissions = ParamUtil.getBoolean(request, "addGroupPermissions");
        boolean addGuestPermissions = ParamUtil.getBoolean(request, "addGuestPermissions");
        String[] groupPermissions = PortalUtil.getGroupPermissions(request);
        String[] guestPermissions = PortalUtil.getGuestPermissions(request);
        serviceContext.setAddGroupPermissions(addGroupPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        serviceContext.setGroupPermissions(groupPermissions);
        serviceContext.setGuestPermissions(guestPermissions);
        String portletId = PortalUtil.getPortletId(request);
        if (Validator.isNotNull(portletId)) {
            PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds(request, portletId);
            serviceContext.setPortletPreferencesIds(portletPreferencesIds);
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration enu = request.getHeaderNames();
        while (enu.hasMoreElements()) {
            String header = (String)enu.nextElement();
            String value = request.getHeader(header);
            headerMap.put(header, value);
        }
        serviceContext.setHeaders(headerMap);
        serviceContext.setRemoteAddr(request.getRemoteAddr());
        serviceContext.setRemoteHost(request.getRemoteHost());
        serviceContext.setRequest(request);
        Map parameterMap = request.getParameterMap();
        ArrayList<Long> assetCategoryIdsList = new ArrayList<Long>();
        boolean updateAssetCategoryIds = false;
        for (Map.Entry entry : parameterMap.entrySet()) {
            long[] assetVocabularyAssetCategoryIds;
            String name = (String)entry.getKey();
            if (!name.startsWith("assetCategoryIds")) continue;
            updateAssetCategoryIds = true;
            long[] lArray = assetVocabularyAssetCategoryIds = StringUtil.split(ParamUtil.getString(request, name), 0L);
            int n = assetVocabularyAssetCategoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                long assetCategoryId = lArray[n2];
                assetCategoryIdsList.add(assetCategoryId);
                ++n2;
            }
        }
        if (updateAssetCategoryIds) {
            long[] assetCategoryIds = ArrayUtil.toArray(assetCategoryIdsList.toArray(new Long[assetCategoryIdsList.size()]));
            serviceContext.setAssetCategoryIds(assetCategoryIds);
        }
        boolean assetEntryVisible = ParamUtil.getBoolean(request, "assetEntryVisible", true);
        serviceContext.setAssetEntryVisible(assetEntryVisible);
        String assetLinkEntryIdsString = request.getParameter("assetLinksSearchContainerPrimaryKeys");
        if (assetLinkEntryIdsString != null) {
            long[] assetLinkEntryIds = StringUtil.split(assetLinkEntryIdsString, 0L);
            serviceContext.setAssetLinkEntryIds(assetLinkEntryIds);
        }
        if ((assetTagNamesString = request.getParameter("assetTagNames")) != null) {
            String[] assetTagNames = StringUtil.split(assetTagNamesString);
            serviceContext.setAssetTagNames(assetTagNames);
        }
        int workflowAction = ParamUtil.getInteger(request, "workflowAction", 1);
        serviceContext.setWorkflowAction(workflowAction);
        return serviceContext;
    }

    public static ServiceContext getInstance(PortletRequest portletRequest) throws PortalException, SystemException {
        String assetTagNamesString;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (serviceContext != null) {
            serviceContext = (ServiceContext)serviceContext.clone();
        } else {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(themeDisplay.getCompanyId());
            serviceContext.setLanguageId(themeDisplay.getLanguageId());
            serviceContext.setLayoutFullURL(PortalUtil.getLayoutFullURL(themeDisplay));
            serviceContext.setLayoutURL(PortalUtil.getLayoutURL(themeDisplay));
            serviceContext.setPathFriendlyURLPrivateGroup(PortalUtil.getPathFriendlyURLPrivateGroup());
            serviceContext.setPathFriendlyURLPrivateUser(PortalUtil.getPathFriendlyURLPrivateUser());
            serviceContext.setPathFriendlyURLPublic(PortalUtil.getPathFriendlyURLPublic());
            serviceContext.setPathMain(PortalUtil.getPathMain());
            serviceContext.setPlid(themeDisplay.getPlid());
            serviceContext.setPortalURL(PortalUtil.getPortalURL(portletRequest));
            serviceContext.setSignedIn(themeDisplay.isSignedIn());
            serviceContext.setTimeZone(themeDisplay.getTimeZone());
            User user = themeDisplay.getUser();
            serviceContext.setUserDisplayURL(user.getDisplayURL(themeDisplay));
            serviceContext.setUserId(user.getUserId());
        }
        serviceContext.setScopeGroupId(themeDisplay.getScopeGroupId());
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        Enumeration enu = portletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            Object[] values = portletRequest.getParameterValues(param);
            if (!ArrayUtil.isNotEmpty(values)) continue;
            if (values.length == 1) {
                attributes.put(param, (Serializable)values[0]);
                continue;
            }
            attributes.put(param, (Serializable)values);
        }
        serviceContext.setAttributes(attributes);
        String cmd = ParamUtil.getString(portletRequest, "cmd");
        serviceContext.setCommand(cmd);
        String currentURL = PortalUtil.getCurrentURL(portletRequest);
        serviceContext.setCurrentURL(currentURL);
        long formDateLong = ParamUtil.getLong(portletRequest, "formDate");
        if (formDateLong > 0L) {
            Date formDate = new Date(formDateLong);
            serviceContext.setFormDate(formDate);
        }
        boolean addGroupPermissions = ParamUtil.getBoolean(portletRequest, "addGroupPermissions");
        boolean addGuestPermissions = ParamUtil.getBoolean(portletRequest, "addGuestPermissions");
        String[] groupPermissions = PortalUtil.getGroupPermissions(portletRequest);
        String[] guestPermissions = PortalUtil.getGuestPermissions(portletRequest);
        serviceContext.setAddGroupPermissions(addGroupPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        serviceContext.setGroupPermissions(groupPermissions);
        serviceContext.setGuestPermissions(guestPermissions);
        HttpServletRequest request = PortalUtil.getHttpServletRequest(portletRequest);
        String portletId = PortalUtil.getPortletId(portletRequest);
        PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds(request, portletId);
        serviceContext.setPortletPreferencesIds(portletPreferencesIds);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        enu = request.getHeaderNames();
        while (enu.hasMoreElements()) {
            String header = (String)enu.nextElement();
            String value = request.getHeader(header);
            headerMap.put(header, value);
        }
        serviceContext.setHeaders(headerMap);
        serviceContext.setRemoteAddr(request.getRemoteAddr());
        serviceContext.setRemoteHost(request.getRemoteHost());
        serviceContext.setRequest(request);
        Map parameterMap = portletRequest.getParameterMap();
        ArrayList<Long> assetCategoryIdsList = new ArrayList<Long>();
        boolean updateAssetCategoryIds = false;
        for (Map.Entry entry : parameterMap.entrySet()) {
            long[] assetVocabularyAssetCategoryIds;
            String name = (String)entry.getKey();
            if (!name.startsWith("assetCategoryIds")) continue;
            updateAssetCategoryIds = true;
            long[] lArray = assetVocabularyAssetCategoryIds = StringUtil.split(ParamUtil.getString(portletRequest, name), 0L);
            int n = assetVocabularyAssetCategoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                long assetCategoryId = lArray[n2];
                assetCategoryIdsList.add(assetCategoryId);
                ++n2;
            }
        }
        if (updateAssetCategoryIds) {
            long[] assetCategoryIds = ArrayUtil.toArray(assetCategoryIdsList.toArray(new Long[assetCategoryIdsList.size()]));
            serviceContext.setAssetCategoryIds(assetCategoryIds);
        }
        boolean assetEntryVisible = ParamUtil.getBoolean(portletRequest, "assetEntryVisible", true);
        serviceContext.setAssetEntryVisible(assetEntryVisible);
        String assetLinkEntryIdsString = request.getParameter("assetLinksSearchContainerPrimaryKeys");
        if (assetLinkEntryIdsString != null) {
            long[] assetLinkEntryIds = StringUtil.split(assetLinkEntryIdsString, 0L);
            serviceContext.setAssetLinkEntryIds(assetLinkEntryIds);
        }
        if ((assetTagNamesString = request.getParameter("assetTagNames")) != null) {
            String[] assetTagNames = StringUtil.split(assetTagNamesString);
            serviceContext.setAssetTagNames(assetTagNames);
        }
        int workflowAction = ParamUtil.getInteger(portletRequest, "workflowAction", 1);
        serviceContext.setWorkflowAction(workflowAction);
        return serviceContext;
    }

    public static ServiceContext getInstance(String className, PortletRequest portletRequest) throws PortalException, SystemException {
        ServiceContext serviceContext = ServiceContextFactory.getInstance(portletRequest);
        String[] groupPermissions = PortalUtil.getGroupPermissions(portletRequest, className);
        String[] guestPermissions = PortalUtil.getGuestPermissions(portletRequest, className);
        if (groupPermissions != null) {
            serviceContext.setGroupPermissions(groupPermissions);
        }
        if (guestPermissions != null) {
            serviceContext.setGuestPermissions(guestPermissions);
        }
        Map<String, Serializable> expandoBridgeAttributes = PortalUtil.getExpandoBridgeAttributes(ExpandoBridgeFactoryUtil.getExpandoBridge(serviceContext.getCompanyId(), className), portletRequest);
        serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        return serviceContext;
    }

    public static ServiceContext getInstance(String className, UploadPortletRequest uploadPortletRequest) throws PortalException, SystemException {
        ServiceContext serviceContext = ServiceContextFactory.getInstance(uploadPortletRequest);
        String[] groupPermissions = PortalUtil.getGroupPermissions(uploadPortletRequest, className);
        String[] guestPermissions = PortalUtil.getGuestPermissions(uploadPortletRequest, className);
        if (groupPermissions != null) {
            serviceContext.setGroupPermissions(groupPermissions);
        }
        if (guestPermissions != null) {
            serviceContext.setGuestPermissions(guestPermissions);
        }
        Map<String, Serializable> expandoBridgeAttributes = PortalUtil.getExpandoBridgeAttributes(ExpandoBridgeFactoryUtil.getExpandoBridge(serviceContext.getCompanyId(), className), uploadPortletRequest);
        serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        return serviceContext;
    }
}

