/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.ControlPanelEntry;
import java.util.List;

public abstract class BaseControlPanelEntry
implements ControlPanelEntry {
    @Override
    public boolean hasAccessPermission(PermissionChecker permissionChecker, Group group, Portlet portlet) throws Exception {
        if (this.hasAccessPermissionDenied(permissionChecker, group, portlet)) {
            return false;
        }
        if (this.hasAccessPermissionExplicitlyGranted(permissionChecker, group, portlet)) {
            return true;
        }
        return this.hasPermissionImplicitlyGranted(permissionChecker, group, portlet);
    }

    @Override
    public boolean isVisible(PermissionChecker permissionChecker, Portlet portlet) throws Exception {
        return false;
    }

    @Override
    public boolean isVisible(Portlet portlet, String category, ThemeDisplay themeDisplay) throws Exception {
        return false;
    }

    protected long getDefaultPlid(Group group, String category) {
        long plid = 0L;
        if (category.startsWith("site_administration.") && (plid = group.getDefaultPublicPlid()) == 0L) {
            plid = group.getDefaultPrivatePlid();
        }
        return plid;
    }

    protected boolean hasAccessPermissionDenied(PermissionChecker permissionChecker, Group group, Portlet portlet) throws Exception {
        String category = portlet.getControlPanelEntryCategory();
        return category.equals("site_administration.content") && group.isLayout() && !portlet.isScopeable();
    }

    protected boolean hasAccessPermissionExplicitlyGranted(PermissionChecker permissionChecker, Group group, Portlet portlet) throws PortalException, SystemException {
        List<String> actions;
        if (permissionChecker.isCompanyAdmin()) {
            return true;
        }
        String category = portlet.getControlPanelEntryCategory();
        if (category == null) {
            category = "";
        }
        if (category.startsWith("site_administration.") && permissionChecker.isGroupAdmin(group.getGroupId()) && !group.isUser()) {
            return true;
        }
        long groupId = group.getGroupId();
        if (category.equals("apps") || category.equals("configuration") || category.equals("sites") || category.equals("users")) {
            groupId = 0L;
        }
        return (actions = ResourceActionsUtil.getResourceActions(portlet.getPortletId())).contains("ACCESS_IN_CONTROL_PANEL") && PortletPermissionUtil.contains(permissionChecker, groupId, this.getDefaultPlid(group, category), portlet.getPortletId(), "ACCESS_IN_CONTROL_PANEL", true);
    }

    protected boolean hasPermissionImplicitlyGranted(PermissionChecker permissionChecker, Group group, Portlet portlet) throws Exception {
        return false;
    }
}

