/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.storage;

import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Fields
implements Iterable<Field>,
Serializable {
    private Map<String, Field> _fieldsMap = new HashMap<String, Field>();

    public boolean contains(String name) {
        return this._fieldsMap.containsKey(name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fields)) {
            return false;
        }
        Fields fields = (Fields)obj;
        return Validator.equals(this._fieldsMap, fields._fieldsMap);
    }

    public Field get(String name) {
        return this._fieldsMap.get(name);
    }

    public Set<Locale> getAvailableLocales() {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (Field field : this._fieldsMap.values()) {
            if (field.isPrivate()) continue;
            for (Locale availableLocale : field.getAvailableLocales()) {
                availableLocales.add(availableLocale);
            }
        }
        return availableLocales;
    }

    public Locale getDefaultLocale() {
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        Iterator<Field> itr = this.iterator();
        if (itr.hasNext()) {
            Field field = itr.next();
            defaultLocale = field.getDefaultLocale();
        }
        return defaultLocale;
    }

    public Set<String> getNames() {
        return this._fieldsMap.keySet();
    }

    @Override
    public Iterator<Field> iterator() {
        return this.iterator(false);
    }

    public Iterator<Field> iterator(boolean includePrivateFields) {
        return this.iterator(null, includePrivateFields);
    }

    public Iterator<Field> iterator(Comparator<Field> comparator, boolean includePrivateFields) {
        Collection<Field> fieldsCollection = this._fieldsMap.values();
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        for (Field field : fieldsCollection) {
            if (!includePrivateFields && field.isPrivate()) continue;
            fieldsList.add(field);
        }
        if (comparator != null) {
            Collections.sort(fieldsList, comparator);
        }
        return fieldsList.iterator();
    }

    public void put(Field field) {
        this._fieldsMap.put(field.getName(), field);
    }

    public Field remove(String name) {
        return this._fieldsMap.remove(name);
    }
}

